# 画面設計書 14-Simple Browser (IComparer)

## 概要

本ドキュメントは、VBCorLibのファイルシステム操作機能とIComparerインターフェースによるカスタムソート機能をデモンストレーションするSimple Browser画面の設計書である。

### 本画面の処理概要

この画面は、Windowsファイルシステムを階層的に閲覧するためのブラウザアプリケーションである。左側のTreeViewにドライブとディレクトリの階層構造を表示し、右側のListViewに選択ディレクトリ内のファイル一覧を表示する。ファイル一覧のソート機能では、IComparerインターフェースを実装したFileComparerクラスを使用する方式を採用している。

**業務上の目的・背景**：VBCorLibが提供するDirectoryInfo、FileInfo、DriveInfo等のファイルシステム操作クラスの使用方法をVB6開発者に紹介することを目的としている。また、.NET Frameworkと同様のIComparerインターフェースを実装したカスタムコンパレータクラスの作成方法とCorArray.Sortでの活用方法をデモンストレーションしている。これはオブジェクト指向設計パターンの実践例でもある。

**画面へのアクセス方法**：SimpleBrowser.vbpプロジェクトをVB6 IDEで開き、実行（F5）することでフォームが起動する。スタートアップフォームとしてForm1が設定されている。

**主要な操作・処理内容**：
1. フォーム起動時にEnvironment.GetLogicalDrivesで全ドライブを取得し、TreeViewに表示
2. TreeViewでドライブまたはディレクトリをクリックすると、サブディレクトリを展開
3. 選択ディレクトリ内のファイル一覧をListViewに表示（ファイル名、サイズ、更新日時）
4. ListViewのカラムヘッダークリックでソート列・ソート順を変更
5. FileComparerクラス（IComparer実装）でファイル配列をソート

**画面遷移**：本画面は独立したデモアプリケーションであり、他の画面への遷移は存在しない。

**権限による表示制御**：特になし。ローカルファイルシステムへの読み取りアクセス権限が必要。アクセス不可のドライブ選択時はエラーメッセージを表示。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 37 | DirectoryInfo | 主機能 | ディレクトリ情報の取得（GetDirectories） |
| 36 | FileInfo | 主機能 | ファイル情報の取得（GetFiles、Name、Length、LastAccessTime） |
| 38 | DriveInfo | 補助機能 | ドライブ準備状態の確認（IsReady、Name） |
| 8 | Environment | 補助機能 | 論理ドライブ一覧の取得（GetLogicalDrives） |
| 1 | CorArray | 補助機能 | ファイル配列のソート（Sort with IComparer） |
| 2 | CorString | 補助機能 | 文字列フォーマット処理（Format） |
| 14 | CorMath | 補助機能 | ファイルサイズの切り上げ計算（Ceiling） |

## 画面種別

一覧（エクスプローラー形式、マスター・ディテール）

## URL/ルーティング

該当なし（VB6デスクトップアプリケーション）

## 入出力項目

### 入力項目

| 項目名 | データ型 | 必須 | 説明 |
|--------|----------|------|------|
| ドライブ/ディレクトリ選択 | Node | Yes | TreeViewでユーザーが選択したノード |
| ソート列選択 | ColumnHeader | No | ListViewでクリックされたカラムヘッダー |

### 出力項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| ドライブ一覧 | String配列 | システム上の全論理ドライブ |
| サブディレクトリ一覧 | DirectoryInfo配列 | 選択ディレクトリ直下のサブディレクトリ |
| ファイル一覧 | FileInfo配列 | 選択ディレクトリ内の全ファイル |

## 表示項目

### ディレクトリツリー（TreeView1）

| 項目名 | 説明 |
|--------|------|
| ドライブ | システム上の論理ドライブ（C:\, D:\ 等） |
| フォルダ | ディレクトリ階層（展開時にサブディレクトリを動的ロード） |

### ファイルリスト（ListView1）

| 列名 | 幅 | 整列 | 説明 |
|------|-----|------|------|
| Name | 2500 twips | 左 | ファイル名 |
| Size | デフォルト | 右 | ファイルサイズ（KB単位、カンマ区切り） |
| Date Modified | 2500 twips | 左 | 最終アクセス日時 |

## イベント仕様

### 1-Form_Load

フォーム初期化時に実行される。

**処理フロー**：
1. FileComparerインスタンスを生成し、mSortComparerに設定
2. 初期ソート列をName、ソート順をAscendingに設定
3. ListView1にカラムヘッダーを追加（Name、Size、Date Modified）
4. ShowDrives関数でドライブ一覧をTreeViewに表示
5. ShowSubDirectories関数で最初のドライブの内容を表示

### 2-TreeView1_Click

TreeViewでノードクリック時に実行される。

**処理フロー**：
1. 選択されたノード（TreeView1.SelectedItem）を取得
2. ShowSubDirectories関数を呼び出し

### 3-ListView1_ColumnClick

ListViewのカラムヘッダークリック時に実行される。

**処理フロー**：
1. クリックされた列が現在のソート列と同じ場合、mSortComparer.SortOrderを反転
2. 異なる列の場合、mSortComparer.SortColumnを更新
3. ShowSubDirectories関数を呼び出してファイル一覧を再表示

### 4-ShowSubDirectories（Private Sub）

選択ノードのサブディレクトリを展開し、ファイル一覧を表示する。

**処理フロー**：
1. NewDirectoryInfoでノードのフルパスからDirectoryInfoを生成
2. NewDriveInfoでドライブ情報を取得し、IsReadyをチェック
3. ドライブ未準備の場合はエラーメッセージを表示して終了
4. ノードに子がない場合、GetDirectoriesでサブディレクトリを取得
5. 各サブディレクトリをTreeViewに追加
6. ShowFiles関数でファイル一覧を表示

### 5-ShowFiles（Private Sub）

指定ディレクトリ内のファイル一覧を表示する。

**処理フロー**：
1. DirectoryInfo.GetFilesでファイル配列を取得
2. CorArray.SortでmSortComparerを指定してソート
3. ListView1をクリア
4. 各ファイルをListView1に追加（Name、Size、LastAccessTime）
5. サイズはCeiling関数で1000で割ってKB単位に変換、N0書式でカンマ区切り

### 6-ShowDrives（Private Sub）

システム上の全ドライブをTreeViewに表示する。

**処理フロー**：
1. Environment.GetLogicalDrivesでドライブ一覧を取得
2. 各ドライブをTreeView1.Nodesに追加
3. 最初のノードを選択状態に設定

### 7-FileComparer.cls（IComparer実装クラス）

CorArray.Sortに渡されるカスタムコンパレータクラス。

**プロパティ**：
- SortColumn: ソート対象列（Name/Size/Modified）
- SortOrder: ソート方向（Ascending/Descending）

**IComparer_Compare実装**：
1. 引数x、yをFileInfo型にキャスト
2. SortColumn（Name/Size/Modified）に応じて比較方法を選択
3. Name: CorString.CompareでOrdinalIgnoreCase比較
4. Size: Sgn関数でファイルサイズ差の符号を取得
5. Modified: cDateTime.CompareToで日時比較
6. SortOrder=Descendingの場合、結果を符号反転

## データベース更新仕様

該当なし（ファイルシステムの読み取りのみ）

## メッセージ仕様

| 種別 | 条件 | メッセージ内容 |
|------|------|---------------|
| エラー | ドライブ未準備 | "Drive '{ドライブ名}' is not ready." |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| ドライブ未準備（IsReady=False） | MsgBoxでエラー表示、処理を中断 |
| ディレクトリアクセスエラー | VBのデフォルトエラー処理に委譲 |

## 備考

- MSCOMCTL.OCX（TreeView、ListView等のコモンコントロール）が必要
- VBCorLib 3.0ライブラリ（vbcorlib3.dll）への参照設定が必要
- FileComparerクラスはIComparerインターフェースを実装
- ImageList1にフォルダアイコン（Closed、Open）が定義されている
- Simple Browser 2（No.12）との違いはソート方式（IComparer vs コールバック）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、IComparerインターフェースとカスタムコンパレータクラスの構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | FileComparer.cls | `Examples/IO Examples/SimpleBrowser/FileComparer.cls` | IComparerインターフェースの実装方法、SortDirection列挙型、SortColumn/SortOrderプロパティの役割を理解する |

**読解のコツ**: VB6のImplementsキーワードでIComparerを実装している。IComparer_Compare関数がソート時に呼び出され、戻り値は負（x<y）、0（x=y）、正（x>y）の3パターン。

#### Step 2: エントリーポイントを理解する

処理の起点となるフォームのイベントハンドラを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Form1.frm | `Examples/IO Examples/SimpleBrowser/Form1.frm` | フォームの初期化処理とユーザー操作によるイベント処理の流れを理解する |

**主要処理フロー**:
1. **行189-206（Form_Load）**: フォーム初期化。FileComparer生成、ListView設定、ドライブ表示
2. **行232-234（TreeView1_Click）**: ディレクトリ選択時の処理
3. **行211-227（ListView1_ColumnClick）**: ソート列/順の変更（mSortComparerプロパティ更新）
4. **行88-125（ShowSubDirectories）**: サブディレクトリ展開とファイル一覧表示
5. **行130-168（ShowFiles）**: ファイル一覧の取得・ソート・表示
6. **行173-184（ShowDrives）**: ドライブ一覧表示

#### Step 3: IComparerインターフェースの理解

カスタムコンパレータクラスの実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | FileComparer.cls | `Examples/IO Examples/SimpleBrowser/FileComparer.cls` | IComparer_Compare関数の実装。3つのソート列（Name、Size、Modified）への対応方法 |

**主要処理フロー**:
- **行21**: Implements IComparer
- **行23-26（SortDirection列挙型）**: Ascending=0、Descending=1
- **行29**: SortColumn変数（Public）
- **行35**: SortOrder変数（Public）
- **行45-74（IComparer_Compare）**: 比較関数本体
- **行46-51**: FileInfo型へのキャスト
- **行58-66**: ソート列別の比較ロジック
- **行73**: Descendingの場合の符号反転

### プログラム呼び出し階層図

```
Form1.frm
    │
    ├─ Form_Load (行189)
    │      ├─ New FileComparer (行193)
    │      │      └─ mSortComparer設定
    │      ├─ ListView1.ColumnHeaders.Add (カラム設定)
    │      ├─ ShowDrives (行173)
    │      │      └─ Environment.GetLogicalDrives (VBCorLib)
    │      └─ ShowSubDirectories (行88)
    │             ├─ NewDirectoryInfo (VBCorLib)
    │             ├─ NewDriveInfo (VBCorLib)
    │             │      └─ DriveInfo.IsReady
    │             ├─ DirectoryInfo.GetDirectories
    │             └─ ShowFiles (行130)
    │                    ├─ DirectoryInfo.GetFiles
    │                    ├─ CorArray.Sort (VBCorLib)
    │                    │      └─ FileComparer.cls
    │                    │             └─ IComparer_Compare (行45)
    │                    │                    ├─ CorString.Compare
    │                    │                    ├─ Sgn(Length)
    │                    │                    └─ cDateTime.CompareTo
    │                    └─ ListView1.ListItems.Add
    │
    ├─ TreeView1_Click (行232)
    │      └─ ShowSubDirectories (再帰的)
    │
    └─ ListView1_ColumnClick (行211)
           ├─ mSortComparer.SortColumn/SortOrder更新
           └─ ShowSubDirectories
```

### データフロー図

```
[入力]                    [処理]                         [出力]

起動時 ─────────────────▶ GetLogicalDrives ──────────▶ ドライブ一覧
                         (行176)                       (TreeView1)
                              │
TreeView選択 ───────────▶ NewDirectoryInfo ──────────▶ DirectoryInfo
(ノードクリック)          (行96)                        (Dir)
                              │
                              ▼
                         GetDirectories ─────────────▶ サブディレクトリ
                         (行111)                       (TreeView1に追加)
                              │
                              ▼
                         GetFiles ───────────────────▶ FileInfo配列
                         (行133)                       (Files)
                              │
                              ▼
                         CorArray.Sort ──────────────▶ ソート済み配列
                         (行136)
                              │    ┌──────────────────────┐
                              │    │ FileComparer.cls      │
                              └───▶│ IComparer_Compare     │
                                   │ - Name: CorString     │
                                   │ - Size: Sgn           │
                                   │ - Modified: CompareTo │
                                   └──────────────────────┘
                              │
                              ▼
                         ListView表示 ───────────────▶ ファイル一覧
                         (行140-167)                   (名前/サイズ/日時)

カラムクリック ─────────▶ mSortComparer更新 ─────────▶ 再ソート・再表示
(ListView1)               (行216-221)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Form1.frm | `Examples/IO Examples/SimpleBrowser/Form1.frm` | ソース | メインフォーム。UI、イベント処理、ファイルシステム操作 |
| Form1.frx | `Examples/IO Examples/SimpleBrowser/Form1.frx` | バイナリ | ImageListのアイコンデータ |
| FileComparer.cls | `Examples/IO Examples/SimpleBrowser/FileComparer.cls` | ソース | IComparer実装のカスタムコンパレータクラス |
| SimpleBrowser.vbp | `Examples/IO Examples/SimpleBrowser/SimpleBrowser.vbp` | プロジェクト | VBプロジェクトファイル |
| vbcorlib3.dll | `Binaries/Compiled/vbcorlib3.dll` | ライブラリ | VBCorLibランタイム |
| MSCOMCTL.OCX | System32 | OCX | TreeView/ListViewコントロール |
